-- a reference to the primary ActorFrame
local args = ...
local t = args[1]
local AlphabetWheels = args[2]
local wordleGame = args[3]
local apple = ""
-- the highscore name character limit
local CharacterLimit = wordleGame.Letters
-- for name,layer in pairs(t:GetChildren()) do
-- 	apple = apple .. " " .. name
-- end
-- SM(apple)
-- Define the input handler
local InputHandler = function(event)

	if not event.PlayerNumber or not event.button or not wordleGame.gameInProgress then
		return false
	end

	local function WordCheck(tab, val)
		for index, value in ipairs(tab) do
			if value == val then
				return true
			end
		end
	
		return false
	end
	-- a local function to delete a character from a player's highscore name
	local function RemoveLastCharacter(pn)
		if wordleGame[pn].currentWord:len() > 0 then
			if wordleGame[pn].Letter > 0 then
				-- remove the last character
				wordleGame[pn].currentWord = wordleGame[pn].currentWord:sub(1, -2)
				t:GetChild(pn.."rowBoxes"..wordleGame[pn].Line):GetChild("letBox"..wordleGame[pn].Letter):GetChild(pn.."Letter"..wordleGame[pn].Letter):queuecommand("Unset")
				wordleGame[pn].Letter = wordleGame[pn].Letter - 1
			end
			-- update the display
			-- play the "delete" sound
			t:GetChild("delete"):playforplayer(event.PlayerNumber)
		else
			-- there's nothing to delete, so play the "invalid" sound
			t:GetChild("invalid"):playforplayer(event.PlayerNumber)
		end
	end


	if event.type ~= "InputEventType_Release" then
		local pn = ToEnumShortString(event.PlayerNumber)

		if event.GameButton == "MenuRight" and wordleGame[pn].EnteringWord then
			-- scroll this player's AlphabetWheel right by 1
			AlphabetWheels[pn]:scroll_by_amount(1)
			t:GetChild("move"):playforplayer(event.PlayerNumber)

		elseif event.GameButton == "MenuLeft" and wordleGame[pn].EnteringWord then
			-- scroll this player's AlphabetWheel left by 1
			AlphabetWheels[pn]:scroll_by_amount(-1)
			t:GetChild("move"):playforplayer(event.PlayerNumber)

		elseif event.GameButton == "Start" then

			if wordleGame[pn].EnteringWord then
				-- This gets us the value selected out of the PossibleCharacters table
				local SelectedCharacter = AlphabetWheels[pn]:get_info_at_focus_pos()

				if SelectedCharacter == "&OK;" then
					if wordleGame[pn].currentWord:len() < CharacterLimit then
						t:GetChild("invalid"):playforplayer(event.PlayerNumber)
					elseif not WordCheck(wordleGame.wordList, wordleGame[pn].currentWord) then
						t:GetChild("invalid"):playforplayer(event.PlayerNumber)
						for name,layer in pairs(t:GetChild(pn.."rowBoxes"..wordleGame[pn].Line):GetChildren()) do
							for name,layer1 in pairs(layer:GetChildren()) do
								apple = apple .. " " .. name
								layer:queuecommand("Unset")
							end
						end
						wordleGame[pn].currentWord = ""
						wordleGame[pn].Letter = 1
					else
						if wordleGame[pn].Line >= wordleGame.Chances then
							wordleGame[pn].EnteringWord = false
						end
						if wordleGame[pn].currentWord == wordleGame[pn].word then
                            wordleGame[pn].solved = true
                        end
						-- hide this player's cursor
						for name,layer in pairs(t:GetChild(pn.."rowBoxes"..wordleGame[pn].Line):GetChildren()) do
							apple = apple .. " " .. name
							layer:queuecommand("Check")
						end
						--t:GetChild(pn.."letBox"..wordleGame[pn].Line):queuecommand("Check")
						wordleGame[pn].guesses[wordleGame[pn].Line] = wordleGame[pn].currentWord
						wordleGame[pn].Line = wordleGame[pn].Line + 1
						wordleGame[pn].currentWord = ""
						
						-- hide this player's AlphabetWheel
						--t:GetChild("AlphabetWheel_"..pn):queuecommand("Hide")
						-- play the "enter" sound
						t:GetChild("enter"):playforplayer(event.PlayerNumber)
					end

				elseif SelectedCharacter == "&BACK;" then
					RemoveLastCharacter(pn)

				else -- it must be a normal character
					if wordleGame[pn].currentWord:len() < CharacterLimit then
						-- append the new character
						wordleGame[pn].currentWord = wordleGame[pn].currentWord .. SelectedCharacter
						wordleGame[pn].lastEnteredLetter = SelectedCharacter
						wordleGame[pn].Letter = wordleGame[pn].currentWord:len()

						-- update the display
						t:GetChild(pn.."rowBoxes"..wordleGame[pn].Line):GetChild("letBox"..wordleGame[pn].Letter):GetChild(pn.."Letter"..wordleGame[pn].Letter):queuecommand("Set")
						-- play the "enter" sound
						t:GetChild("enter"):playforplayer(event.PlayerNumber)
					else
						t:GetChild("invalid"):playforplayer(event.PlayerNumber)
					end

					if wordleGame[pn].currentWord:len() >= CharacterLimit then
						AlphabetWheels[pn]:scroll_to_pos(2)
					end

				end

			end

			-- check if we're ready to save scores and proceed to the next screen
			t:queuecommand("AttemptToFinish")

		elseif event.GameButton == "Select" and wordleGame[pn].EnteringWord then
			RemoveLastCharacter(pn)
		end
	end

	return false
end

return InputHandler
